set define off verify off feedback off
whenever sqlerror exit sql.sqlcode rollback
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_050100 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2016.08.24'
,p_release=>'5.1.3.00.05'
,p_default_workspace_id=>1821013086265845
,p_default_application_id=>100
,p_default_owner=>'DEMO'
);
end;
/
prompt --application/ui_types
begin
null;
end;
/
prompt --application/shared_components/plugins/item_type/printnow
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(6473098234305094)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'PRINTNOW'
,p_display_name=>'PrintNow'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'/**',
'www.apex-reports.com',
'*/',
'function render_PrintNow (',
'    p_item                in apex_plugin.t_page_item,',
'    p_plugin              in apex_plugin.t_plugin,',
'    p_value               in varchar2,',
'    p_is_readonly         in boolean,',
'    p_is_printer_friendly in boolean )',
'    return apex_plugin.t_page_item_render_result',
'is',
'    l_result apex_plugin.t_page_item_render_result; ',
'    l_reportURL varchar2(200);',
'    l_msg varchar2(200);',
'    l_buttonclass   varchar2(100);  ',
'    l_buttonlabelclass   varchar2(100);  ',
'begin',
'',
'',
'/*',
'',
'att_01: report URL',
'att_02: label',
'att_03: css class',
'att_04: css class label',
'**/',
'',
' l_reportURL:=p_item.attribute_01;',
' l_msg:=p_item.attribute_02; ',
' l_buttonclass:=p_item.attribute_03;',
' l_buttonlabelclass:=p_item.attribute_04;',
' /*',
' l_buttonclass := ''t-Button'';',
'l_buttonlabelclass := ''t-Button-label'';',
'*/',
'',
'apex_javascript.add_library (',
'        p_name      => ''printnow'',',
'        p_directory => p_plugin.file_prefix,',
'        p_version   => null );',
'',
'apex_javascript.add_library (',
'        p_name      => ''print.min'',',
'        p_directory => p_plugin.file_prefix,',
'        p_version   => null );',
'',
'',
'sys.htp.p(''<button id="j4lprintbtn" onclick=j4lprint("'' || l_reportURL || ''") class="'' || l_buttonclass || ''" value="''  ||  l_msg ||   ''" type="button" ''   ||  p_item.element_attributes  ||  ''><span  class="'' || l_buttonlabelclass || ''" >''  ||  l_msg'
||' ||   ''</span></button>'');',
'',
'',
'return l_result;',
'',
'end render_PrintNow;',
'',
''))
,p_api_version=>1
,p_render_function=>'render_PrintNow'
,p_standard_attributes=>'VISIBLE:SESSION_STATE:SOURCE:ELEMENT'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
,p_about_url=>'http://www.apex-reports.com'
,p_files_version=>434
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(6473256641305118)
,p_plugin_id=>wwv_flow_api.id(6473098234305094)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Report query URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(6481804407644788)
,p_plugin_id=>wwv_flow_api.id(6473098234305094)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Button label'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'Print now'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(6474041112305122)
,p_plugin_id=>wwv_flow_api.id(6473098234305094)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>60
,p_prompt=>'Button label class'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'t-Button-label'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(6474823027305123)
,p_plugin_id=>wwv_flow_api.id(6473098234305094)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Button class'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'t-Button'
,p_is_translatable=>false
);
end;
/
begin
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '2166756E6374696F6E28652C74297B226F626A656374223D3D747970656F66206578706F7274732626226F626A656374223D3D747970656F66206D6F64756C653F6D6F64756C652E6578706F7274733D7428293A2266756E6374696F6E223D3D74797065';
wwv_flow_api.g_varchar2_table(2) := '6F6620646566696E652626646566696E652E616D643F646566696E6528227072696E742D6A73222C5B5D2C74293A226F626A656374223D3D747970656F66206578706F7274733F6578706F7274735B227072696E742D6A73225D3D7428293A655B227072';
wwv_flow_api.g_varchar2_table(3) := '696E742D6A73225D3D7428297D28746869732C66756E6374696F6E28297B72657475726E2066756E6374696F6E2865297B66756E6374696F6E20742869297B6966286E5B695D2972657475726E206E5B695D2E6578706F7274733B766172206F3D6E5B69';
wwv_flow_api.g_varchar2_table(4) := '5D3D7B693A692C6C3A21312C6578706F7274733A7B7D7D3B72657475726E20655B695D2E63616C6C286F2E6578706F7274732C6F2C6F2E6578706F7274732C74292C6F2E6C3D21302C6F2E6578706F7274737D766172206E3D7B7D3B72657475726E2074';
wwv_flow_api.g_varchar2_table(5) := '2E6D3D652C742E633D6E2C742E693D66756E6374696F6E2865297B72657475726E20657D2C742E643D66756E6374696F6E28652C6E2C69297B742E6F28652C6E297C7C4F626A6563742E646566696E6550726F706572747928652C6E2C7B636F6E666967';
wwv_flow_api.g_varchar2_table(6) := '757261626C653A21312C656E756D657261626C653A21302C6765743A697D297D2C742E6E3D66756E6374696F6E2865297B766172206E3D652626652E5F5F65734D6F64756C653F66756E6374696F6E28297B72657475726E20652E64656661756C747D3A';
wwv_flow_api.g_varchar2_table(7) := '66756E6374696F6E28297B72657475726E20657D3B72657475726E20742E64286E2C2261222C6E292C6E7D2C742E6F3D66756E6374696F6E28652C74297B72657475726E204F626A6563742E70726F746F747970652E6861734F776E50726F7065727479';
wwv_flow_api.g_varchar2_table(8) := '2E63616C6C28652C74297D2C742E703D222E2F222C7428742E733D3130297D285B66756E6374696F6E28652C742C6E297B2275736520737472696374223B66756E6374696F6E206928652C74297B696628652E666F63757328292C722E612E6973456467';
wwv_flow_api.g_varchar2_table(9) := '6528297C7C722E612E697349452829297472797B652E636F6E74656E7457696E646F772E646F63756D656E742E65786563436F6D6D616E6428227072696E74222C21312C6E756C6C297D63617463682874297B652E636F6E74656E7457696E646F772E70';
wwv_flow_api.g_varchar2_table(10) := '72696E7428297D722E612E6973494528297C7C722E612E69734564676528297C7C652E636F6E74656E7457696E646F772E7072696E7428292C722E612E697349452829262622706466223D3D3D742E74797065262673657454696D656F75742866756E63';
wwv_flow_api.g_varchar2_table(11) := '74696F6E28297B652E706172656E744E6F64652E72656D6F76654368696C642865297D2C326533292C742E73686F774D6F64616C2626612E612E636C6F736528292C742E6F6E4C6F6164696E67456E642626742E6F6E4C6F6164696E67456E6428297D66';
wwv_flow_api.g_varchar2_table(12) := '756E6374696F6E206F28652C742C6E297B766F696420303D3D3D652E6E61747572616C57696474687C7C303D3D3D652E6E61747572616C57696474683F73657454696D656F75742866756E6374696F6E28297B6F28652C742C6E297D2C353030293A6928';
wwv_flow_api.g_varchar2_table(13) := '742C6E297D76617220723D6E2831292C613D6E2833292C643D7B73656E643A66756E6374696F6E28652C74297B646F63756D656E742E676574456C656D656E747342795461674E616D652822626F647922295B305D2E617070656E644368696C64287429';
wwv_flow_api.g_varchar2_table(14) := '3B766172206E3D646F63756D656E742E676574456C656D656E744279496428652E6672616D654964293B22706466223D3D3D652E74797065262628722E612E6973494528297C7C722E612E6973456467652829293F6E2E73657441747472696275746528';
wwv_flow_api.g_varchar2_table(15) := '226F6E6C6F6164222C69286E2C6529293A742E6F6E6C6F61643D66756E6374696F6E28297B69662822706466223D3D3D652E747970652969286E2C65293B656C73657B76617220743D6E2E636F6E74656E7457696E646F777C7C6E2E636F6E74656E7444';
wwv_flow_api.g_varchar2_table(16) := '6F63756D656E743B742E646F63756D656E74262628743D742E646F63756D656E74292C742E626F64792E696E6E657248544D4C3D652E68746D6C446174612C22696D616765223D3D3D652E747970653F6F28742E676574456C656D656E74427949642822';
wwv_flow_api.g_varchar2_table(17) := '7072696E7461626C65496D61676522292C6E2C65293A69286E2C65297D7D7D7D3B742E613D647D2C66756E6374696F6E28652C742C6E297B2275736520737472696374223B76617220693D7B697346697265666F783A66756E6374696F6E28297B726574';
wwv_flow_api.g_varchar2_table(18) := '75726E22756E646566696E656422213D747970656F6620496E7374616C6C547269676765727D2C697349453A66756E6374696F6E28297B72657475726E2D31213D3D6E6176696761746F722E757365724167656E742E696E6465784F6628224D53494522';
wwv_flow_api.g_varchar2_table(19) := '297C7C2121646F63756D656E742E646F63756D656E744D6F64657D2C6973456467653A66756E6374696F6E28297B72657475726E21692E6973494528292626212177696E646F772E5374796C654D656469617D2C69734368726F6D653A66756E6374696F';
wwv_flow_api.g_varchar2_table(20) := '6E28297B72657475726E212177696E646F772E6368726F6D652626212177696E646F772E6368726F6D652E77656273746F72657D2C69735361666172693A66756E6374696F6E28297B72657475726E204F626A6563742E70726F746F747970652E746F53';
wwv_flow_api.g_varchar2_table(21) := '7472696E672E63616C6C2877696E646F772E48544D4C456C656D656E74292E696E6465784F662822436F6E7374727563746F7222293E307C7C2D31213D3D6E6176696761746F722E757365724167656E742E746F4C6F7765724361736528292E696E6465';
wwv_flow_api.g_varchar2_table(22) := '784F66282273616661726922297D7D3B742E613D697D2C66756E6374696F6E28652C742C6E297B2275736520737472696374223B66756E6374696F6E206928652C74297B72657475726E273C646976207374796C653D22666F6E742D66616D696C793A27';
wwv_flow_api.g_varchar2_table(23) := '2B742E666F6E742B222021696D706F7274616E743B20666F6E742D73697A653A20222B742E666F6E745F73697A652B272021696D706F7274616E743B2077696474683A313030253B223E272B652B223C2F6469763E227D66756E6374696F6E206F286529';
wwv_flow_api.g_varchar2_table(24) := '7B72657475726E20652E6368617241742830292E746F55707065724361736528292B652E736C6963652831297D66756E6374696F6E207228652C74297B766172206E3D646F63756D656E742E64656661756C74566965777C7C77696E646F772C693D5B5D';
wwv_flow_api.g_varchar2_table(25) := '2C6F3D22223B6966286E2E676574436F6D70757465645374796C65297B693D6E2E676574436F6D70757465645374796C6528652C2222293B76617220723D742E7461726765745374796C65737C7C5B22626F72646572222C22626F78222C22627265616B';
wwv_flow_api.g_varchar2_table(26) := '222C22746578742D6465636F726174696F6E225D2C613D742E7461726765745374796C657C7C5B22636C656172222C22646973706C6179222C227769647468222C226D696E2D7769647468222C22686569676874222C226D696E2D686569676874222C22';
wwv_flow_api.g_varchar2_table(27) := '6D61782D686569676874225D3B742E686F6E6F724D617267696E50616464696E672626722E7075736828226D617267696E222C2270616464696E6722292C742E686F6E6F72436F6C6F722626722E707573682822636F6C6F7222293B666F722876617220';
wwv_flow_api.g_varchar2_table(28) := '643D303B643C692E6C656E6774683B642B2B29666F7228766172206C3D303B6C3C722E6C656E6774683B6C2B2B29222A22213D3D725B6C5D26262D313D3D3D695B645D2E696E6465784F6628725B6C5D2926262D313D3D3D612E696E6465784F6628695B';
wwv_flow_api.g_varchar2_table(29) := '645D297C7C286F2B3D695B645D2B223A222B692E67657450726F706572747956616C756528695B645D292B223B22297D656C736520696628652E63757272656E745374796C65297B693D652E63757272656E745374796C653B666F722876617220732069';
wwv_flow_api.g_varchar2_table(30) := '6E2069292D31213D3D692E696E6465784F662822626F72646572222926262D31213D3D692E696E6465784F662822636F6C6F7222292626286F2B3D732B223A222B695B735D2B223B22297D72657475726E206F2B3D226D61782D77696474683A20222B74';
wwv_flow_api.g_varchar2_table(31) := '2E6D617857696474682B2270782021696D706F7274616E743B222B742E666F6E745F73697A652B222021696D706F7274616E743B227D66756E6374696F6E206128652C74297B666F7228766172206E3D303B6E3C652E6C656E6774683B6E2B2B297B7661';
wwv_flow_api.g_varchar2_table(32) := '7220693D655B6E5D2C6F3D692E7461674E616D653B69662822494E505554223D3D3D6F7C7C225445585441524541223D3D3D6F7C7C2253454C454354223D3D3D6F297B76617220643D7228692C74292C6C3D692E706172656E744E6F64652C733D225345';
wwv_flow_api.g_varchar2_table(33) := '4C454354223D3D3D6F3F646F63756D656E742E637265617465546578744E6F646528692E6F7074696F6E735B692E73656C6563746564496E6465785D2E74657874293A646F63756D656E742E637265617465546578744E6F646528692E76616C7565292C';
wwv_flow_api.g_varchar2_table(34) := '633D646F63756D656E742E637265617465456C656D656E74282264697622293B632E617070656E644368696C642873292C632E73657441747472696275746528227374796C65222C64292C6C2E617070656E644368696C642863292C6C2E72656D6F7665';
wwv_flow_api.g_varchar2_table(35) := '4368696C642869297D656C736520692E73657441747472696275746528227374796C65222C7228692C7429293B76617220703D692E6368696C6472656E3B702626702E6C656E67746826266128702C74297D7D66756E6374696F6E206428652C742C6E29';
wwv_flow_api.g_varchar2_table(36) := '7B76617220693D646F63756D656E742E637265617465456C656D656E742822683122292C6F3D646F63756D656E742E637265617465546578744E6F64652874293B692E617070656E644368696C64286F292C692E73657441747472696275746528227374';
wwv_flow_api.g_varchar2_table(37) := '796C65222C6E292C652E696E736572744265666F726528692C652E6368696C644E6F6465735B305D297D742E613D692C742E623D6F2C742E633D722C742E643D612C742E653D647D2C66756E6374696F6E28652C742C6E297B2275736520737472696374';
wwv_flow_api.g_varchar2_table(38) := '223B76617220693D7B73686F773A66756E6374696F6E2865297B76617220743D646F63756D656E742E637265617465456C656D656E74282264697622293B742E73657441747472696275746528227374796C65222C22666F6E742D66616D696C793A7361';
wwv_flow_api.g_varchar2_table(39) := '6E732D73657269663B20646973706C61793A7461626C653B20746578742D616C69676E3A63656E7465723B20666F6E742D7765696768743A3330303B20666F6E742D73697A653A333070783B206C6566743A303B20746F703A303B706F736974696F6E3A';
wwv_flow_api.g_varchar2_table(40) := '66697865643B207A2D696E6465783A20393939303B636F6C6F723A20233034363042353B2077696474683A20313030253B206865696768743A20313030253B206261636B67726F756E642D636F6C6F723A72676261283235352C3235352C3235352C2E39';
wwv_flow_api.g_varchar2_table(41) := '293B7472616E736974696F6E3A206F706163697479202E337320656173653B22292C742E73657441747472696275746528226964222C227072696E744A532D4D6F64616C22293B766172206E3D646F63756D656E742E637265617465456C656D656E7428';
wwv_flow_api.g_varchar2_table(42) := '2264697622293B6E2E73657441747472696275746528227374796C65222C22646973706C61793A7461626C652D63656C6C3B20766572746963616C2D616C69676E3A6D6964646C653B2070616464696E672D626F74746F6D3A31303070783B22293B7661';
wwv_flow_api.g_varchar2_table(43) := '72206F3D646F63756D656E742E637265617465456C656D656E74282264697622293B6F2E7365744174747269627574652822636C617373222C227072696E74436C6F736522292C6F2E73657441747472696275746528226964222C227072696E74436C6F';
wwv_flow_api.g_varchar2_table(44) := '736522292C6E2E617070656E644368696C64286F293B76617220723D646F63756D656E742E637265617465456C656D656E7428227370616E22293B722E7365744174747269627574652822636C617373222C227072696E745370696E6E657222292C6E2E';
wwv_flow_api.g_varchar2_table(45) := '617070656E644368696C642872293B76617220613D646F63756D656E742E637265617465546578744E6F646528652E6D6F64616C4D657373616765293B6E2E617070656E644368696C642861292C742E617070656E644368696C64286E292C646F63756D';
wwv_flow_api.g_varchar2_table(46) := '656E742E676574456C656D656E747342795461674E616D652822626F647922295B305D2E617070656E644368696C642874292C646F63756D656E742E676574456C656D656E744279496428227072696E74436C6F736522292E6164644576656E744C6973';
wwv_flow_api.g_varchar2_table(47) := '74656E65722822636C69636B222C66756E6374696F6E28297B692E636C6F736528297D297D2C636C6F73653A66756E6374696F6E28297B76617220653D646F63756D656E742E676574456C656D656E744279496428227072696E744A532D4D6F64616C22';
wwv_flow_api.g_varchar2_table(48) := '293B652E706172656E744E6F64652E72656D6F76654368696C642865297D7D3B742E613D697D2C66756E6374696F6E28652C742C6E297B2275736520737472696374223B4F626A6563742E646566696E6550726F706572747928742C225F5F65734D6F64';
wwv_flow_api.g_varchar2_table(49) := '756C65222C7B76616C75653A21307D293B76617220693D6E2837292C6F3D692E612E696E69743B22756E646566696E656422213D747970656F662077696E646F7726262877696E646F772E7072696E744A533D6F292C742E64656661756C743D6F7D2C66';
wwv_flow_api.g_varchar2_table(50) := '756E6374696F6E28652C742C6E297B2275736520737472696374223B76617220693D6E2832292C6F3D6E2830293B742E613D7B7072696E743A66756E6374696F6E28652C74297B76617220723D646F63756D656E742E676574456C656D656E7442794964';
wwv_flow_api.g_varchar2_table(51) := '28652E7072696E7461626C65293B69662821722972657475726E2077696E646F772E636F6E736F6C652E6572726F722822496E76616C69642048544D4C20656C656D656E742069643A20222B652E7072696E7461626C65292C21313B76617220613D646F';
wwv_flow_api.g_varchar2_table(52) := '63756D656E742E637265617465456C656D656E74282264697622293B612E617070656E644368696C6428722E636C6F6E654E6F646528213029292C612E73657441747472696275746528227374796C65222C22646973706C61793A6E6F6E653B22292C61';
wwv_flow_api.g_varchar2_table(53) := '2E73657441747472696275746528226964222C227072696E744A532D68746D6C22292C722E706172656E744E6F64652E617070656E644368696C642861292C613D646F63756D656E742E676574456C656D656E744279496428227072696E744A532D6874';
wwv_flow_api.g_varchar2_table(54) := '6D6C22292C612E73657441747472696275746528227374796C65222C6E2E6928692E632928612C65292B226D617267696E3A302021696D706F7274616E743B22293B76617220643D612E6368696C6472656E3B6E2E6928692E642928642C65292C652E68';
wwv_flow_api.g_varchar2_table(55) := '656164657226266E2E6928692E652928612C652E6865616465722C652E6865616465725374796C65292C612E706172656E744E6F64652E72656D6F76654368696C642861292C652E68746D6C446174613D6E2E6928692E612928612E696E6E657248544D';
wwv_flow_api.g_varchar2_table(56) := '4C2C65292C6F2E612E73656E6428652C74297D7D7D2C66756E6374696F6E28652C742C6E297B2275736520737472696374223B76617220693D6E2832292C6F3D6E2830293B742E613D7B7072696E743A66756E6374696F6E28652C74297B76617220723D';
wwv_flow_api.g_varchar2_table(57) := '646F63756D656E742E637265617465456C656D656E742822696D6722293B722E7372633D652E7072696E7461626C652C722E6F6E6C6F61643D66756E6374696F6E28297B722E73657441747472696275746528227374796C65222C2277696474683A3130';
wwv_flow_api.g_varchar2_table(58) := '30253B22292C722E73657441747472696275746528226964222C227072696E7461626C65496D61676522293B76617220613D646F63756D656E742E637265617465456C656D656E74282264697622293B612E73657441747472696275746528227374796C';
wwv_flow_api.g_varchar2_table(59) := '65222C2277696474683A3130302522292C612E617070656E644368696C642872292C652E68656164657226266E2E6928692E652928612C652E6865616465722C652E6865616465725374796C65292C652E68746D6C446174613D612E6F7574657248544D';
wwv_flow_api.g_varchar2_table(60) := '4C2C6F2E612E73656E6428652C74297D7D7D7D2C66756E6374696F6E28652C742C6E297B2275736520737472696374223B76617220693D6E2831292C6F3D6E2833292C723D6E2839292C613D6E2835292C643D6E2836292C6C3D6E2838292C733D226675';
wwv_flow_api.g_varchar2_table(61) := '6E6374696F6E223D3D747970656F662053796D626F6C26262273796D626F6C223D3D747970656F662053796D626F6C2E6974657261746F723F66756E6374696F6E2865297B72657475726E20747970656F6620657D3A66756E6374696F6E2865297B7265';
wwv_flow_api.g_varchar2_table(62) := '7475726E206526262266756E6374696F6E223D3D747970656F662053796D626F6C2626652E636F6E7374727563746F723D3D3D53796D626F6C262665213D3D53796D626F6C2E70726F746F747970653F2273796D626F6C223A747970656F6620657D2C63';
wwv_flow_api.g_varchar2_table(63) := '3D5B22706466222C2268746D6C222C22696D616765222C226A736F6E225D3B742E613D7B696E69743A66756E6374696F6E28297B76617220653D7B7072696E7461626C653A6E756C6C2C66616C6C6261636B5072696E7461626C653A6E756C6C2C747970';
wwv_flow_api.g_varchar2_table(64) := '653A22706466222C6865616465723A6E756C6C2C6865616465725374796C653A22666F6E742D7765696768743A203330303B222C6D617857696474683A3830302C666F6E743A2254696D65734E6577526F6D616E222C666F6E745F73697A653A22313270';
wwv_flow_api.g_varchar2_table(65) := '74222C686F6E6F724D617267696E50616464696E673A21302C686F6E6F72436F6C6F723A21312C70726F706572746965733A6E756C6C2C677269644865616465725374796C653A22666F6E742D7765696768743A20626F6C643B222C677269645374796C';
wwv_flow_api.g_varchar2_table(66) := '653A22626F726465723A2031707820736F6C6964206C69676874677261793B206D617267696E2D626F74746F6D3A202D3170783B222C73686F774D6F64616C3A21312C6F6E4C6F6164696E6753746172743A66756E6374696F6E28297B7D2C6F6E4C6F61';
wwv_flow_api.g_varchar2_table(67) := '64696E67456E643A66756E6374696F6E28297B7D2C6D6F64616C4D6573736167653A2252657472696576696E6720446F63756D656E742E2E2E222C6672616D6549643A227072696E744A53222C68746D6C446174613A22222C646F63756D656E74546974';
wwv_flow_api.g_varchar2_table(68) := '6C653A22446F63756D656E74222C7461726765745374796C653A6E756C6C2C7461726765745374796C65733A6E756C6C7D2C743D617267756D656E74735B305D3B696628766F696420303D3D3D74297468726F77206E6577204572726F7228227072696E';
wwv_flow_api.g_varchar2_table(69) := '744A532065787065637473206174206C656173742031206174747269627574652E22293B73776974636828766F696420303D3D3D743F22756E646566696E6564223A73287429297B6361736522737472696E67223A652E7072696E7461626C653D656E63';
wwv_flow_api.g_varchar2_table(70) := '6F64655552492874292C652E66616C6C6261636B5072696E7461626C653D652E7072696E7461626C652C652E747970653D617267756D656E74735B315D7C7C652E747970653B627265616B3B63617365226F626A656374223A652E7072696E7461626C65';
wwv_flow_api.g_varchar2_table(71) := '3D742E7072696E7461626C652C652E66616C6C6261636B5072696E7461626C653D766F69642030213D3D742E66616C6C6261636B5072696E7461626C653F742E66616C6C6261636B5072696E7461626C653A652E7072696E7461626C652C652E74797065';
wwv_flow_api.g_varchar2_table(72) := '3D766F69642030213D3D742E747970653F742E747970653A652E747970652C652E6672616D6549643D766F69642030213D3D742E6672616D6549643F742E6672616D6549643A652E6672616D6549642C652E6865616465723D766F69642030213D3D742E';
wwv_flow_api.g_varchar2_table(73) := '6865616465723F742E6865616465723A652E6865616465722C652E6865616465725374796C653D766F69642030213D3D742E6865616465725374796C653F742E6865616465725374796C653A652E6865616465725374796C652C652E6D61785769647468';
wwv_flow_api.g_varchar2_table(74) := '3D766F69642030213D3D742E6D617857696474683F742E6D617857696474683A652E6D617857696474682C652E666F6E743D766F69642030213D3D742E666F6E743F742E666F6E743A652E666F6E742C652E666F6E745F73697A653D766F69642030213D';
wwv_flow_api.g_varchar2_table(75) := '3D742E666F6E745F73697A653F742E666F6E745F73697A653A652E666F6E745F73697A652C652E686F6E6F724D617267696E50616464696E673D766F69642030213D3D742E686F6E6F724D617267696E50616464696E673F742E686F6E6F724D61726769';
wwv_flow_api.g_varchar2_table(76) := '6E50616464696E673A652E686F6E6F724D617267696E50616464696E672C652E70726F706572746965733D766F69642030213D3D742E70726F706572746965733F742E70726F706572746965733A652E70726F706572746965732C652E67726964486561';
wwv_flow_api.g_varchar2_table(77) := '6465725374796C653D766F69642030213D3D742E677269644865616465725374796C653F742E677269644865616465725374796C653A652E677269644865616465725374796C652C652E677269645374796C653D766F69642030213D3D742E6772696453';
wwv_flow_api.g_varchar2_table(78) := '74796C653F742E677269645374796C653A652E677269645374796C652C652E73686F774D6F64616C3D766F69642030213D3D742E73686F774D6F64616C3F742E73686F774D6F64616C3A652E73686F774D6F64616C2C652E6F6E4C6F6164696E67537461';
wwv_flow_api.g_varchar2_table(79) := '72743D766F69642030213D3D742E6F6E4C6F6164696E6753746172743F742E6F6E4C6F6164696E6753746172743A652E6F6E4C6F6164696E6753746172742C652E6F6E4C6F6164696E67456E643D766F69642030213D3D742E6F6E4C6F6164696E67456E';
wwv_flow_api.g_varchar2_table(80) := '643F742E6F6E4C6F6164696E67456E643A652E6F6E4C6F6164696E67456E642C652E6D6F64616C4D6573736167653D766F69642030213D3D742E6D6F64616C4D6573736167653F742E6D6F64616C4D6573736167653A652E6D6F64616C4D657373616765';
wwv_flow_api.g_varchar2_table(81) := '2C652E646F63756D656E745469746C653D766F69642030213D3D742E646F63756D656E745469746C653F742E646F63756D656E745469746C653A652E646F63756D656E745469746C652C652E7461726765745374796C653D766F69642030213D3D742E74';
wwv_flow_api.g_varchar2_table(82) := '61726765745374796C653F742E7461726765745374796C653A652E7461726765745374796C652C652E7461726765745374796C65733D766F69642030213D3D742E7461726765745374796C65733F742E7461726765745374796C65733A652E7461726765';
wwv_flow_api.g_varchar2_table(83) := '745374796C65733B627265616B3B64656661756C743A7468726F77206E6577204572726F722827556E657870656374656420617267756D656E742074797065212045787065637465642022737472696E6722206F7220226F626A656374222C20676F7420';
wwv_flow_api.g_varchar2_table(84) := '272B28766F696420303D3D3D743F22756E646566696E6564223A7328742929297D69662821652E7072696E7461626C65297468726F77206E6577204572726F7228224D697373696E67207072696E7461626C6520696E666F726D6174696F6E2E22293B69';
wwv_flow_api.g_varchar2_table(85) := '662821652E747970657C7C22737472696E6722213D747970656F6620652E747970657C7C2D313D3D3D632E696E6465784F6628652E747970652E746F4C6F77657243617365282929297468726F77206E6577204572726F722822496E76616C6964207072';
wwv_flow_api.g_varchar2_table(86) := '696E7420747970652E20417661696C61626C65207479706573206172653A207064662C2068746D6C2C20696D61676520616E64206A736F6E2E22293B652E73686F774D6F64616C26266F2E612E73686F772865292C652E6F6E4C6F6164696E6753746172';
wwv_flow_api.g_varchar2_table(87) := '742626652E6F6E4C6F6164696E67537461727428293B766172206E3D646F63756D656E742E676574456C656D656E744279496428652E6672616D654964293B6E26266E2E706172656E744E6F64652E72656D6F76654368696C64286E293B76617220703D';
wwv_flow_api.g_varchar2_table(88) := '766F696420303B73776974636828703D646F63756D656E742E637265617465456C656D656E742822696672616D6522292C702E73657441747472696275746528227374796C65222C22646973706C61793A6E6F6E653B22292C702E736574417474726962';
wwv_flow_api.g_varchar2_table(89) := '75746528226964222C652E6672616D654964292C2270646622213D3D652E74797065262628702E737263646F633D223C68746D6C3E3C686561643E3C7469746C653E222B652E646F63756D656E745469746C652B223C2F7469746C653E3C2F686561643E';
wwv_flow_api.g_varchar2_table(90) := '3C626F64793E3C2F626F64793E3C2F68746D6C3E22292C652E74797065297B6361736522706466223A696628692E612E697346697265666F7828297C7C692E612E69734564676528297C7C692E612E697349452829297B77696E646F772E6F70656E2865';
wwv_flow_api.g_varchar2_table(91) := '2E66616C6C6261636B5072696E7461626C652C225F626C616E6B22292E666F63757328292C652E73686F774D6F64616C26266F2E612E636C6F736528292C652E6F6E4C6F6164696E67456E642626652E6F6E4C6F6164696E67456E6428297D656C736520';
wwv_flow_api.g_varchar2_table(92) := '722E612E7072696E7428652C70293B627265616B3B6361736522696D616765223A642E612E7072696E7428652C70293B627265616B3B636173652268746D6C223A612E612E7072696E7428652C70293B627265616B3B63617365226A736F6E223A6C2E61';
wwv_flow_api.g_varchar2_table(93) := '2E7072696E7428652C70293B627265616B3B64656661756C743A7468726F77206E6577204572726F722822496E76616C6964207072696E7420747970652E20417661696C61626C65207479706573206172653A207064662C2068746D6C2C20696D616765';
wwv_flow_api.g_varchar2_table(94) := '20616E64206A736F6E2E22297D7D7D7D2C66756E6374696F6E28652C742C6E297B2275736520737472696374223B66756E6374696F6E20692865297B76617220743D652E7072696E7461626C652C693D652E70726F706572746965732C723D273C646976';
wwv_flow_api.g_varchar2_table(95) := '207374796C653D22646973706C61793A666C65783B20666C65782D646972656374696F6E3A20636F6C756D6E3B223E273B722B3D273C646976207374796C653D22666C65783A312031206175746F3B20646973706C61793A666C65783B223E273B666F72';
wwv_flow_api.g_varchar2_table(96) := '2876617220613D303B613C692E6C656E6774683B612B2B29722B3D273C646976207374796C653D22666C65783A313B2070616464696E673A3570783B272B652E677269644865616465725374796C652B27223E272B6E2E69286F2E622928695B615D292B';
wwv_flow_api.g_varchar2_table(97) := '223C2F6469763E223B722B3D223C2F6469763E223B666F722876617220643D303B643C742E6C656E6774683B642B2B297B722B3D273C646976207374796C653D22666C65783A312031206175746F3B20646973706C61793A666C65783B223E273B666F72';
wwv_flow_api.g_varchar2_table(98) := '28766172206C3D303B6C3C692E6C656E6774683B6C2B2B297B76617220733D745B645D2C633D695B6C5D2E73706C697428222E22293B696628632E6C656E6774683E3129666F722876617220703D303B703C632E6C656E6774683B702B2B29733D735B63';
wwv_flow_api.g_varchar2_table(99) := '5B705D5D3B656C736520733D735B695B6C5D5D3B722B3D273C646976207374796C653D22666C65783A313B2070616464696E673A3570783B272B652E677269645374796C652B27223E272B732B223C2F6469763E227D722B3D223C2F6469763E227D7265';
wwv_flow_api.g_varchar2_table(100) := '7475726E20722B3D223C2F6469763E227D766172206F3D6E2832292C723D6E2830292C613D2266756E6374696F6E223D3D747970656F662053796D626F6C26262273796D626F6C223D3D747970656F662053796D626F6C2E6974657261746F723F66756E';
wwv_flow_api.g_varchar2_table(101) := '6374696F6E2865297B72657475726E20747970656F6620657D3A66756E6374696F6E2865297B72657475726E206526262266756E6374696F6E223D3D747970656F662053796D626F6C2626652E636F6E7374727563746F723D3D3D53796D626F6C262665';
wwv_flow_api.g_varchar2_table(102) := '213D3D53796D626F6C2E70726F746F747970653F2273796D626F6C223A747970656F6620657D3B742E613D7B7072696E743A66756E6374696F6E28652C74297B696628226F626A65637422213D3D6128652E7072696E7461626C6529297468726F77206E';
wwv_flow_api.g_varchar2_table(103) := '6577204572726F722822496E76616C6964206A6176617363726970742064617461206F626A65637420284A534F4E292E22293B69662821652E70726F706572746965737C7C226F626A65637422213D3D6128652E70726F7065727469657329297468726F';
wwv_flow_api.g_varchar2_table(104) := '77206E6577204572726F722822496E76616C69642070726F7065727469657320617272617920666F7220796F7572204A534F4E20646174612E22293B76617220643D22223B652E686561646572262628642B3D273C6831207374796C653D22272B652E68';
wwv_flow_api.g_varchar2_table(105) := '65616465725374796C652B27223E272B652E6865616465722B223C2F68313E22292C642B3D692865292C652E68746D6C446174613D6E2E69286F2E612928642C65292C722E612E73656E6428652C74297D7D7D2C66756E6374696F6E28652C742C6E297B';
wwv_flow_api.g_varchar2_table(106) := '2275736520737472696374223B66756E6374696F6E206928652C74297B742E7365744174747269627574652822737263222C652E7072696E7461626C65292C722E612E73656E6428652C74297D766172206F3D6E2831292C723D6E2830293B742E613D7B';
wwv_flow_api.g_varchar2_table(107) := '7072696E743A66756E6374696F6E28652C74297B696628652E73686F774D6F64616C7C7C652E6F6E4C6F6164696E6753746172747C7C6F2E612E697349452829297B766172206E3D6E65772077696E646F772E584D4C48747470526571756573743B6E2E';
wwv_flow_api.g_varchar2_table(108) := '6164644576656E744C697374656E657228226C6F6164222C6928652C7429292C6E2E6F70656E2822474554222C77696E646F772E6C6F636174696F6E2E6F726967696E2B222F222B652E7072696E7461626C652C2130292C6E2E73656E6428297D656C73';
wwv_flow_api.g_varchar2_table(109) := '65206928652C74297D7D7D2C66756E6374696F6E28652C742C6E297B652E6578706F7274733D6E2834297D5D297D293B';
null;
end;
/
begin
wwv_flow_api.create_plugin_file(
 p_id=>wwv_flow_api.id(6476772104399385)
,p_plugin_id=>wwv_flow_api.id(6473098234305094)
,p_file_name=>'print.min.js'
,p_mime_type=>'text/javascript'
,p_file_charset=>'utf-8'
,p_file_content=>wwv_flow_api.varchar2_to_blob(wwv_flow_api.g_varchar2_table)
);
end;
/
begin
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := 'EFBBBF66756E6374696F6E206A346C7072696E74287355524C29207B09200D0A0D0A2020202020696628286E6176696761746F722E757365724167656E742E696E6465784F6628224F706572612229207C7C206E6176696761746F722E75736572416765';
wwv_flow_api.g_varchar2_table(2) := '6E742E696E6465784F6628274F505227292920213D202D312029200D0A202020207B0D0A20202020202020207072696E744352287355524C293B0D0A202020207D0D0A20202020656C7365206966286E6176696761746F722E757365724167656E742E69';
wwv_flow_api.g_varchar2_table(3) := '6E6465784F6628224368726F6D65222920213D202D3120290D0A202020207B0D0A20202020202020207072696E744352287355524C293B0D0A202020207D0D0A20202020656C7365206966286E6176696761746F722E757365724167656E742E696E6465';
wwv_flow_api.g_varchar2_table(4) := '784F662822536166617269222920213D202D31290D0A202020207B0D0A20202020202020207072696E744352287355524C293B0D0A202020207D0D0A20202020656C7365206966286E6176696761746F722E757365724167656E742E696E6465784F6628';
wwv_flow_api.g_varchar2_table(5) := '2246697265666F78222920213D202D312029200D0A202020207B0D0A20202020202020207072696E744352287355524C293B0D0A202020207D0D0A20202020656C736520696628286E6176696761746F722E757365724167656E742E696E6465784F6628';
wwv_flow_api.g_varchar2_table(6) := '224D534945222920213D202D312029207C7C20282121646F63756D656E742E646F63756D656E744D6F6465203D3D2074727565202929202F2F4946204945203E2031300D0A202020207B0D0A09097072696E744352287355524C293B200D0A202020207D';
wwv_flow_api.g_varchar2_table(7) := '20200D0A20202020656C7365200D0A202020207B0D0A2020202020207072696E744352287355524C293B0D0A202020207D0D0A090D0A7D0D0A0D0A0D0A2F2F204348524F4D450D0A2066756E6374696F6E207072696E744352287355524C29207B0D0A20';
wwv_flow_api.g_varchar2_table(8) := '2020200D0A2020202020207072696E744A53287355524C293B0D0A7D0D0A';
null;
end;
/
begin
wwv_flow_api.create_plugin_file(
 p_id=>wwv_flow_api.id(6477152594400445)
,p_plugin_id=>wwv_flow_api.id(6473098234305094)
,p_file_name=>'printnow.js'
,p_mime_type=>'text/javascript'
,p_file_charset=>'utf-8'
,p_file_content=>wwv_flow_api.varchar2_to_blob(wwv_flow_api.g_varchar2_table)
);
end;
/
begin
wwv_flow_api.import_end(p_auto_install_sup_obj => nvl(wwv_flow_application_install.get_auto_install_sup_obj, false), p_is_component_import => true);
commit;
end;
/
set verify on feedback on define on
prompt  ...done
